<?php
require_once '../config/cors.php';
require_once '../config/database.php';

$database = new Database();
$db = $database->getConnection();

$userId = $_GET['user_id'] ?? null;

if (!$userId) {
    echo json_encode(['error' => 'User ID required']);
    exit;
}

try {
    // Get all cart items for this user
    $stmt = $db->prepare("SELECT * FROM cart_items WHERE user_id = :user_id ORDER BY added_at DESC");
    $stmt->bindParam(':user_id', $userId);
    $stmt->execute();
    $items = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo json_encode([
        'user_id' => $userId,
        'total_items' => count($items),
        'items' => $items
    ], JSON_PRETTY_PRINT);
    
} catch (Exception $e) {
    echo json_encode(['error' => $e->getMessage()]);
}
?>