<?php
require_once '../config/cors.php';
require_once '../config/database.php';
require_once '../models/Product.php';
require_once '../middleware/auth.php';

$database = new Database();
$db = $database->getConnection();
$product = new Product($db);

$method = $_SERVER['REQUEST_METHOD'];
$id = isset($_GET['id']) ? $_GET['id'] : null;

if (!$id) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => 'Product ID is required'
    ]);
    exit();
}

switch($method) {
    case 'GET':
        // Get single product
        try {
            $productData = $product->getProductById($id);
            
            if ($productData) {
                http_response_code(200);
                echo json_encode([
                    'success' => true,
                    'product' => $productData
                ]);
            } else {
                http_response_code(404);
                echo json_encode([
                    'success' => false,
                    'message' => 'Product not found'
                ]);
            }
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode([
                'success' => false,
                'message' => 'Internal server error'
            ]);
        }
        break;

    case 'PUT':
        // Update product (Admin only)
        $user = requireAdmin();
        
        $data = json_decode(file_get_contents("php://input"));

        if (!$data) {
            http_response_code(400);
            echo json_encode([
                'success' => false,
                'message' => 'Invalid JSON data'
            ]);
            break;
        }

        $product->id = $id;
        $product->name = isset($data->name) ? $data->name : '';
        $product->brand = isset($data->brand) ? $data->brand : '';
        $product->description = isset($data->description) ? $data->description : '';
        $product->base_price = isset($data->base_price) ? $data->base_price : 0;
        $product->stock = isset($data->stock) ? $data->stock : 0;
        $product->category_id = isset($data->category_id) ? $data->category_id : '';

        try {
            if ($product->update()) {
                http_response_code(200);
                echo json_encode([
                    'success' => true,
                    'message' => 'Product updated successfully'
                ]);
            } else {
                http_response_code(400);
                echo json_encode([
                    'success' => false,
                    'message' => 'Failed to update product'
                ]);
            }
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode([
                'success' => false,
                'message' => 'Internal server error'
            ]);
        }
        break;

    case 'DELETE':
        // Delete product (Admin only)
        $user = requireAdmin();
        
        $product->id = $id;

        try {
            if ($product->delete()) {
                http_response_code(200);
                echo json_encode([
                    'success' => true,
                    'message' => 'Product deleted successfully'
                ]);
            } else {
                http_response_code(400);
                echo json_encode([
                    'success' => false,
                    'message' => 'Failed to delete product'
                ]);
            }
        } catch (Exception $e) {
            http_response_code(500);
            echo json_encode([
                'success' => false,
                'message' => 'Internal server error'
            ]);
        }
        break;

    default:
        http_response_code(405);
        echo json_encode([
            'success' => false,
            'message' => 'Method not allowed'
        ]);
        break;
}
?>